<?php
session_start();
require '../../conexion.php';
require_once('../../include/sesiones.php');

// Cabeceras para forzar descarga como Excel
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=ventas_por_categoria.xls");
header("Pragma: no-cache");
header("Expires: 0");

// Parámetros
$fecha_desde = $_GET['fecha_desde'];
$fecha_hasta = $_GET['fecha_hasta'];
$art_categoria = $_GET['art_categoria'];
$vendedores = implode("','", $_GET["vendedor3"]);
$sucursal_form = $_GET['sucursal_form'];

// Inicio del HTML con estilos embebidos
echo "
<html>
<head>
<meta charset='UTF-8'>
<style>
    body { font-family: Arial, sans-serif; }
    table { border-collapse: collapse; width: 100%; }
    th, td { border: 1px solid #999; padding: 5px; font-size: 12px; }
    th { background-color: #f2f2f2; }
    .categoria { background-color: #cfe2f3; font-weight: bold; text-align: center; }
    .encabezado { background-color: #fce5cd; font-weight: bold; text-align: center; }
    .total_categoria { background-color: #d9ead3; font-weight: bold; text-align: right; }
    .total_general { background-color: #ffe599; font-weight: bold; text-align: right; }
    .right { text-align: right; }
</style>
</head>
<body>
<h3>VENTAS POR CATEGORÍA Y EMPLEADO DESDE $fecha_desde HASTA $fecha_hasta</h3>
<table>
";

// Consulta de datos (igual que antes)
$sql = "SELECT * FROM venta_detalle d
    JOIN ventas v ON d.ventas_ven_id = v.ven_id
    JOIN articulos a ON a.art_id = d.vend_art_id
    JOIN familias f ON f.fam_id = a.familias_fam_id
WHERE 
    v.ven_estado <> 'anulada'
    AND v.ven_fecha BETWEEN '$fecha_desde' AND '$fecha_hasta'
    AND v.sucursal='$sucursal_form'
    AND v.empresa='$empresa'";

if ($art_categoria != 0) {
    $sql .= " AND a.familias_fam_id = '$art_categoria'";
}
if ($facturador == 'si') {
    $ven_tipo = implode("','", $_GET["ven_tipo10"]);
    $sql .= " AND v.ven_tipo IN ('$ven_tipo') ORDER BY f.fam_nombre ASC ";
}

$query = mysqli_query($con, $sql);

$agrupado_categoria = [];
$resumen_categoria = [];

while ($row = mysqli_fetch_array($query)) {
    $fam_nombre = $row['fam_nombre'];
    $vend_art_id = $row['vend_art_id'];
    $vend_referencia = $row['vend_referencia'];
    $vend_nombre = $row['vend_nombre'];
    $vend_unidad = $row['vend_unidad'];
    $vend_cantidad = $row['vend_cantidad'];
    $vend_x_cantidad = $row['vend_x_cantidad'];
    $vend_precio = $row['vend_precio'];
    $vend_iva = ($row['vend_iva'] > 0) ? $row['vend_iva'] : 0;
    $vend_descuento = ($row['vend_desc'] > 0) ? $row['vend_desc'] : 0;

    $iva0 = $vend_iva / 100;
    $iva1 = 1 + $iva0;

    $precio_total_sin_iva_item = ($vend_precio / $iva1) * $vend_cantidad;
    $descuento_item = ($vend_descuento / 100) * $precio_total_sin_iva_item;
    $precio_real_item = $precio_total_sin_iva_item - $descuento_item;
    $total_iva_item = $precio_real_item * $iva0;

   if (!isset($agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id])) {
        $agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id] = [
            'vend_referencia' => $vend_referencia,
            'vend_nombre' => $vend_nombre,
            'vend_unidad' => $vend_unidad,
            'vend_cantidad' => 0,
            'subtotal_art' => 0,
            'iva_art' => 0,
            'total_art' => 0
        ];
    }

    $agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id]['vend_cantidad'] += $vend_cantidad;
    $agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id]['subtotal_art'] += $precio_real_item;
    $agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id]['iva_art'] += $total_iva_item;
    $agrupado_categoria[$fam_nombre][$vend_unidad][$vend_art_id]['total_art'] += $precio_real_item + $total_iva_item;


    if (!isset($resumen_categoria[$fam_nombre])) {
        $resumen_categoria[$fam_nombre] = ['subtotal' => 0, 'iva' => 0, 'total' => 0];
    }

    $resumen_categoria[$fam_nombre]['subtotal'] += $precio_real_item;
    $resumen_categoria[$fam_nombre]['iva'] += $total_iva_item;
    $resumen_categoria[$fam_nombre]['total'] += $precio_real_item + $total_iva_item;
}

$sumador_total_general = 0;

foreach ($agrupado_categoria as $fam_nombre => $unidades) {
    echo "<tr><td colspan='6' class='categoria'>$fam_nombre</td></tr>";
    echo "<tr class='encabezado'>
            <th>REF</th><th>CANTIDAD</th><th>UM</th><th>NOMBRE</th><th>PRECIO U</th><th>PRECIO T</th>
          </tr>";

        foreach ($unidades as $unidad => $articulos) {
    
       
        if (is_array($articulos) && !empty($articulos)) {
            uasort($articulos, function($a, $b) {
                return strcasecmp($a['vend_nombre'], $b['vend_nombre']);
            });
        }
    

    foreach ($articulos as $articulo) {
        $vend_referencia = $articulo['vend_referencia'];
        $vend_nombre = $articulo['vend_nombre'];
        $vend_unidad = $articulo['vend_unidad'];
        $vend_cantidad = $articulo['vend_cantidad'];
        $total_art = $articulo['total_art'];

        $precio_promedio = $vend_cantidad > 0 ? $total_art / $vend_cantidad : 0;

        echo "<tr>
                <td>$vend_referencia</td>
                <td class='right'>" . $vend_cantidad . "</td>
                <td>$vend_unidad</td>
                <td>" . utf8_decode($vend_nombre) . "</td>
                <td class='right'>" . $precio_promedio . "</td>
                <td class='right'>" . $total_art . "</td>
              </tr>";
    }
}

    $total = $resumen_categoria[$fam_nombre]['total'];
    $sumador_total_general += $total;

    echo "<tr class='total_categoria'>
            <td colspan='5'>TOTAL</td>
            <td class='right'>" . $total . "</td>
          </tr>";
}

echo "<tr class='total_general'>
        <td colspan='5'>TOTAL GENERAL</td>
        <td class='right'>" . $sumador_total_general . "</td>
      </tr>";

echo "</table></body></html>";
exit;
?>
