<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:D1')->mergeCells('A2:D2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:D2', 'BDBDBD'); 
cellColor('A1:D1', 'BDBDBD'); 
cellColor('A3:D3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE PROVEEDORES')
            ->setCellValue('A2', '')
            ->setCellValue('A3', 'DOCUMENTO')
            ->setCellValue('B3', 'NOMBRE')
            ->setCellValue('C3', 'CORREO')
            ->setCellValue('D3', 'TELEFONO');
            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(15);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20);

 $cel=4;//Numero de fila donde empezara a crear  el reporte

$query=mysqli_query($con, "SELECT * FROM proveedor where empresa='$empresa' ORDER BY pro_nombre ASC ");


 while ($roww=mysqli_fetch_array($query))   
    {
                    
        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
                  
        // Agregar datos
        $sheet
        ->setCellValue($a, $roww['pro_nit'])
        ->setCellValue($b, $roww['pro_nombre'])
        ->setCellValue($c, $roww['pro_correo'])
        ->setCellValue($d, $roww['pro_telefono']);
        
        
        $cel+=1;

    }

// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE PROVEEDORES.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>