<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];
$vendedores=$_GET['vendedores'];
$estado=$_GET['estado'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:H1')->mergeCells('A2:H2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:H2', 'BDBDBD'); 
cellColor('A1:H1', 'BDBDBD'); 
cellColor('A3:H3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE PEDIDO DETALLADO')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta);
            

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(10);   
$sheet->getColumnDimension('B')->setWidth(15);  
$sheet->getColumnDimension('C')->setWidth(35); 
$sheet->getColumnDimension('D')->setWidth(15); 
$sheet->getColumnDimension('E')->setWidth(40);
$sheet->getColumnDimension('F')->setWidth(10);
$sheet->getColumnDimension('G')->setWidth(15);
$sheet->getColumnDimension('H')->setWidth(15);



$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

    $cel=3;//Numero de fila donde empezara a crear  el reporte


$total_general=0;

     $query=mysqli_query($con, "SELECT * FROM cotizacion where cot_fecha BETWEEN '$desde' AND '$hasta'  and sucursal='$sucursal' and empresa='$empresa' and cot_estado='$estado' and vendedor IN('".$vendedores."')  order by cot_id desc");


       
    while ($roww=mysqli_fetch_array($query))    
    {


        $cot_id=$roww['cot_id'];
        $cot_n_cotizacion=$roww['cot_n_cotizacion'];
        $cot_cc=$roww['cot_cc'];
        $cot_nombre=$roww['cot_nombre'];
        $cot_fecha=$roww['cot_fecha'];

        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        $f="F".$cel;
        $g="G".$cel;
        $h="H".$cel;
                  
        // Agregar datos
        $sheet->setCellValue($a, '# PEDIDO')
        ->setCellValue($b, 'CC/NIT')
        ->setCellValue($c, 'CLIENTE')
        ->setCellValue($d, 'FECHA')
        ->setCellValue($e, 'PRODUCTOS')
        ->setCellValue($f, 'CANTIDAD')
        ->setCellValue($g, 'PRECIO')
        ->setCellValue($h, 'TOTAL');            

        /* color a las celdas con funsion*/            
        cellColor('A'.$cel.':H'.$cel, 'FF4D00');

        $cel+=1;


        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        // Agregar datos
        $sheet->mergeCells("E".($cel).":H".($cel))
        ->setCellValue($a, $cot_n_cotizacion)
        ->setCellValue($b, $cot_cc)
        ->setCellValue($c, $cot_nombre)
        ->setCellValue($d, $cot_fecha);

        cellColor('E'.$cel.':H'.$cel, 'FFFFFF');
        $cel+=1; 

            

            $sumador_total=0;
            $cotd=mysqli_query($con, "SELECT * FROM cotizacion_detalle where cotizacion_cot_id='$cot_id' and empresa='$empresa'");
            while($resuld=mysqli_fetch_array($cotd))
            
            {

                $cotd_referencia=$resuld['cotd_referencia'];
                $cotd_nombre=$resuld['cotd_nombre'];
                $cotd_cantidad=$resuld['cotd_cantidad'];
                $cotd_precio=$resuld['cotd_precio'];

                $total=$cotd_cantidad*$cotd_precio;


                $e="E".$cel;
                $f="F".$cel;
                $g="G".$cel;
                $h="H".$cel;
               
                $sheet->mergeCells("A".($cel).":D".($cel))
                ->setCellValue($e, $cotd_nombre)
                ->setCellValue($f, $cotd_cantidad)
                ->setCellValue($g, number_format($cotd_precio))
                ->setCellValue($h, number_format($total,0));
          
                $cel+=1; 

                $sumador_total+=$total;
               


            } 

                $g="G".$cel;
                $h="H".$cel;
               
                $sheet->mergeCells("A".($cel).":F".($cel))
               
                ->setCellValue($g, 'TOTAL')
                ->setCellValue($h, number_format($sumador_total,0));

                cellColor('G'.$cel.':H'.$cel, 'fdfd96');

                 $cel+=1;

                 $total_general+=$sumador_total; 
            
    } 
            $a="A".$cel;
            $f="F".$cel;

            // Agregar datos
            $sheet->mergeCells("A".($cel).":F".($cel));
            $cel+=1;


            $g="G".$cel;
            $h="H".$cel;

            // Agregar datos
            $sheet->mergeCells("A".($cel).":F".($cel))
            ->setCellValue($g, 'TOTAL GENERAL')
            ->setCellValue($h, number_format($total_general));


            cellColor('A'.$cel.':H'.$cel, 'BDBDBD');


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE PEDIDO DETALLADO.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>