<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:E1')->mergeCells('A2:E2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:E2', 'BDBDBD'); 
cellColor('A1:E1', 'BDBDBD'); 
cellColor('A3:E3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VENTAS DEVOLUCIONES')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'FECHA')
            ->setCellValue('B3', 'CANTIDAD')
            ->setCellValue('C3', 'REFERENCIA')
            ->setCellValue('D3', 'NOMBRE')
            ->setCellValue('E3', 'PRECIO');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(30);   
$sheet->getColumnDimension('B')->setWidth(10);  
$sheet->getColumnDimension('C')->setWidth(10); 
$sheet->getColumnDimension('D')->setWidth(40); 
$sheet->getColumnDimension('E')->setWidth(20);


    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$total=0;
$registros=mysqli_query($con,"SELECT * FROM devolucion where dev_fecha BETWEEN '$desde' AND '$hasta' and empresa='$empresa' order by dev_id desc") or die(mysqli_error($con));
while ($reg=mysqli_fetch_array($registros))
{


    $a="A".$cel;
    $b="B".$cel;
    $c="C".$cel;
    $d="D".$cel;
    $e="E".$cel;
    
    // Agregar datos
    $sheet
    ->setCellValue($a, $reg['dev_fecha'])
    ->setCellValue($b, $reg['dev_cantidad'])
    ->setCellValue($c, $reg['dev_referencia'])
    ->setCellValue($d, $reg['dev_nombre'])
    ->setCellValue($e, number_format($reg['dev_precio']));
    
     $cel+=1;

    $total+=$reg['dev_precio'];
}  


        $d="D".$cel;
        $e="E".$cel;

        // Agregar datos
        $sheet->mergeCells("A".($cel).":C".($cel))
        ->setCellValue($d, 'TOTAL GENERAL')
        ->setCellValue($e, number_format($total,0));

        cellColor('A'.$cel.':E'.$cel, 'BDBDBD');

        $cel+=1;


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VENTAS DEVOLUCIONES.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>