<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];
$proveedor=$_GET['proveedor'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:E1')->mergeCells('A2:E2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:E2', 'BDBDBD'); 
cellColor('A1:E1', 'BDBDBD'); 
cellColor('A3:E3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VENTAS POR PROVEEDOR')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'CANT')
            ->setCellValue('B3', 'NOMBRE')
            ->setCellValue('C3', 'PROVEEDOR')
            ->setCellValue('D3', 'COSTO')
            ->setCellValue('E3', 'VENTA');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(5);   
$sheet->getColumnDimension('B')->setWidth(30);  
$sheet->getColumnDimension('C')->setWidth(30); 
$sheet->getColumnDimension('D')->setWidth(10); 
$sheet->getColumnDimension('E')->setWidth(10);


    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

if ($proveedor==0) 
{
    $sql1=mysqli_query($con, "SELECT * from proveedor where empresa='$empresa' order by pro_nombre asc");
}
else
{
    $sql1=mysqli_query($con, "SELECT * from proveedor where pro_id='$proveedor' and empresa='$empresa' order by pro_nombre asc");
}

$costo_general=0;
$total_general=0;

while ($cos=mysqli_fetch_array($sql1))
{
    $pro_nombre=$cos['pro_nombre'];  
    $pro_id=$cos['pro_id'];
    $suma_costo=0;
    $suma=0;
    $sql=mysqli_query($con,"SELECT *,sum(vend_cantidad_dev) as vend_cantidad_dev from venta_detalle d,ventas v,articulos a 
    where d.ventas_ven_id=v.ven_id and v.ven_estado<>'anulada' and v.ven_fecha BETWEEN '$desde' AND '$hasta' 
    and v.sucursal='$sucursal' and v.empresa='$empresa' and a.art_id=d.vend_art_id and a.proveedor_pro_id='$pro_id' group by vend_art_id  
    order by vend_nombre asc"); 
    while ($row=mysqli_fetch_array($sql))
    {
        $vend_nombre=$row['vend_nombre'];
        $vend_cantidad=$row['vend_cantidad_dev'];
        $vend_precio_real=$row['vend_precio_real'];
        $vend_costo=$row['art_precio_costo'];

        $suma_costo+=$vend_cantidad*$vend_costo;
        $suma+=$vend_cantidad*$vend_precio_real;
       
       

        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        

         $sheet->setCellValue($a, $vend_cantidad)
        ->setCellValue($b, utf8_decode($vend_nombre))
        ->setCellValue($c, utf8_decode($pro_nombre))
        ->setCellValue($d, number_format($suma_costo,0))
        ->setCellValue($e, number_format($suma,0));

    $cel+=1;

    }

    $costo_general+=$suma_costo;
    $total_general+=$suma;
} 

        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;

        // Agregar datos
        $sheet->mergeCells("A".($cel).":B".($cel))
        ->setCellValue($c, 'TOTAL GENERAL')
        ->setCellValue($d,  number_format($costo_general,0))
        ->setCellValue($e,  number_format($total_general,0));

          cellColor('A'.$cel.':E'.$cel, 'BDBDBD');


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VENTAS POR PROVEEDOR.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>