<style>


	.accordion {
		--bs-accordion-color:rgb(255, 255, 255);
		--bs-accordion-bg: rgb(255, 255, 255);
		--bs-accordion-transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out, border-radius 0.15s ease;
		--bs-accordion-border-color: var(--bs-border-color);
		--bs-accordion-border-width: 1px;
		--bs-accordion-border-radius: 0.375rem;
		--bs-accordion-inner-border-radius: calc(0.375rem - 1px);
		--bs-accordion-btn-padding-x: 1.25rem;
		--bs-accordion-btn-padding-y: 1rem;
		--bs-accordion-btn-color: #212529;
		--bs-accordion-btn-bg: var(--bs-accordion-bg);
		--bs-accordion-btn-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%23212529'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");
		--bs-accordion-btn-icon-width: 1.25rem;	
		--bs-accordion-btn-icon-transform: rotate(-180deg);
		--bs-accordion-btn-icon-transition: transform 0.2s ease-in-out;
		--bs-accordion-btn-active-icon: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16' fill='%230c63e4'%3e%3cpath fill-rule='evenodd' d='M1.646 4.646a.5.5 0 0 1 .708 0L8 10.293l5.646-5.647a.5.5 0 0 1 .708.708l-6 6a.5.5 0 0 1-.708 0l-6-6a.5.5 0 0 1 0-.708z'/%3e%3c/svg%3e");
		--bs-accordion-btn-focus-border-color:rgb(251, 251, 252);
		--bs-accordion-btn-focus-box-shadow: 0 0 0 0.25rem rgb(255, 255, 255);
		--bs-accordion-body-padding-x: 1.25rem;
		--bs-accordion-body-padding-y: 1rem;
		--bs-accordion-active-color: #ffffff;
		--bs-accordion-active-bg: #<?php echo $conf_color;?>
	}

	.accordion-button {
		position: relative;
		display: flex;
		align-items: center;
		width: 100%;
		padding: var(--bs-accordion-btn-padding-y) var(--bs-accordion-btn-padding-x);
		font-size: 1rem;
		color: var(--bs-accordion-btn-color);
		text-align: left;
		background-color: var(--bs-accordion-btn-bg);
		border: 0;
		border-radius: 0;
		overflow-anchor: none;
		transition: var(--bs-accordion-transition)
	}

	@media (prefers-reduced-motion:reduce) {
		.accordion-button {
			transition: none
		}
	}

	.accordion-button:not(.collapsed) {
		color: var(--bs-accordion-active-color);
		background-color: var(--bs-accordion-active-bg);
		box-shadow: inset 0 calc(-1 * var(--bs-accordion-border-width)) 0 var(--bs-accordion-border-color)
	}

	.accordion-button:not(.collapsed)::after {
		background-image: var(--bs-accordion-btn-active-icon);
		transform: var(--bs-accordion-btn-icon-transform)
	}

	.accordion-button::after {
		flex-shrink: 0;
		width: var(--bs-accordion-btn-icon-width);
		height: var(--bs-accordion-btn-icon-width);
		margin-left: auto;
		content: "";
		background-image: var(--bs-accordion-btn-icon);
		background-repeat: no-repeat;
		background-size: var(--bs-accordion-btn-icon-width);
		transition: var(--bs-accordion-btn-icon-transition)
	}

	@media (prefers-reduced-motion:reduce) {
		.accordion-button::after {
			transition: none
		}
	}

	.accordion-button:hover {
		z-index: 2
	}

	.accordion-button:focus {
		z-index: 3;
		border-color: var(--bs-accordion-btn-focus-border-color);
		outline: 0;
		box-shadow: var(--bs-accordion-btn-focus-box-shadow)
	}

	.accordion-header {
		margin-bottom: 0
	}

	.accordion-item {
		color: var(--bs-accordion-color);
		background-color: var(--bs-accordion-bg);
		border: var(--bs-accordion-border-width) solid var(--bs-accordion-border-color)
	}

	.accordion-item:first-of-type {
		border-top-left-radius: var(--bs-accordion-border-radius);
		border-top-right-radius: var(--bs-accordion-border-radius)
	}

	.accordion-item:first-of-type .accordion-button {
		border-top-left-radius: var(--bs-accordion-inner-border-radius);
		border-top-right-radius: var(--bs-accordion-inner-border-radius)
	}

	.accordion-item:not(:first-of-type) {
		border-top: 0
	}

	.accordion-item:last-of-type {
		border-bottom-right-radius: var(--bs-accordion-border-radius);
		border-bottom-left-radius: var(--bs-accordion-border-radius)
	}

	.accordion-item:last-of-type .accordion-button.collapsed {
		border-bottom-right-radius: var(--bs-accordion-inner-border-radius);
		border-bottom-left-radius: var(--bs-accordion-inner-border-radius)
	}

	.accordion-item:last-of-type .accordion-collapse {
		border-bottom-right-radius: var(--bs-accordion-border-radius);
		border-bottom-left-radius: var(--bs-accordion-border-radius)
	}

	.accordion-body {
		padding: var(--bs-accordion-body-padding-y) var(--bs-accordion-body-padding-x)
	}

	.accordion-flush .accordion-collapse {
		border-width: 0
	}

	.accordion-flush .accordion-item {
		border-right: 0;
		border-left: 0;
		border-radius: 0
	}

	.accordion-flush .accordion-item:first-child {
		border-top: 0
	}

	.accordion-flush .accordion-item:last-child {
		border-bottom: 0
	}

	.accordion-flush .accordion-item .accordion-button,
	.accordion-flush .accordion-item .accordion-button.collapsed {
		border-radius: 0
	}

	
</style>