<?php
$info = detect();

function detect()
{
    $os = array("WIN", "MAC", "LINUX", "androide");
    $info['os'] = "OTHER";
    foreach ($os as $val) {
        if (strpos(strtoupper($_SERVER['HTTP_USER_AGENT']), $val) !== false)
            $info['os'] = $val;
    }
    return $info;
}

session_start();
require_once('../conexion.php');
require_once('../include/sesiones.php');
require "../libraries/php_qr/qrlib.php";
if (isset($_SESSION['usu_nombre']))
{
?>
<style type="text/css">
    /* --- RESET Y BASE --- */
    body {
        margin: 0;
        padding: 0; /* Ajustado para que el wrapper controle el margen */
        font-family: Tahoma, Geneva, sans-serif;
        font-size: 13px;
        color: #000;
        background-color: #fff;
    }

    /* --- CONTENEDOR PRINCIPAL --- */
    #receipt_wrapper {
        margin: 0 auto;
        background: white;
        padding: 10px; 
        box-sizing: border-box; 
    }

    /* --- HEADER (Empresa) --- */
    #receipt_header {
        text-align: center;
        margin-bottom: 10px;
        width: 100%;
    }
    #company_name {
        font-weight: bold;
        font-size: 1.2em;
        text-transform: uppercase;
    }
    #company_nit, #company_address, #company_phone, #regimen {
        margin: 2px 0;
    }
    #sale_time {
        margin: 5px 0;
        font-size: 0.9em;
    }
    /* --- INFORMACIÓN GENERAL (Cliente/Vendedor) --- */
    #receipt_general_info {
        margin: 5px 0;
        border-bottom: 1px dashed #000;
        padding-bottom: 5px;
    }
    #receipt_general_info div {
        margin-bottom: 2px;
    }
    .receipt-numero-factura {
        font-weight: bold;
        font-size: 1.1em;
        margin-bottom: 5px;
    }
    /* --- TABLA DE ITEMS --- */
    #receipt_items {
        width: 100%;
        border-collapse: collapse;
        margin-top: 10px;
        margin-bottom: 10px;
    }
   #receipt_items th {
        text-align: left;
        border-bottom: 1px solid #000;
        font-size: 0.9em;
        padding: 3px 2px; /* Espacio en el encabezado */
    }
    #receipt_items td {
        /* AQUI EL CAMBIO PRINCIPAL: 5px arriba/abajo y 2px a los lados */
        padding: 3px ; 
        vertical-align: top;
        line-height: 1.1;
    }

    /* Columnas específicas */
    .receipt-item-cell-description { width: 65%; }
    .receipt-item-cell-quantity { width: 15%; text-align: center; }
    .receipt-item-cell-price { width: 20%; text-align: right; }

    /* Utilidades de texto */
    .my-text-align-right { text-align: right !important; }
    .my-text-align-center { text-align: center !important; }
    .my-text-align-left { text-align: left !important; }
    .my-strong { font-weight: bold; }

    /* --- TOTALES --- */
    .receipt-row-line td {
        border-top: 1px solid #000;
        padding: 0;
        height: 1px;
    }
    .receipt-row-totales td {
        padding-top: 5px;
        text-align: right;
    }
    .receipt-row-total td {
        font-weight: bold;
        font-size: 1.1em;
        border-top: 1px solid #000;
        padding-top: 5px;
        text-align: right;
    }
    /* --- FOOTER --- */
    #observaciones {
        margin-top: 10px;
        border-top: 1px dashed #000;
        padding-top: 5px;
    }
    #sale_return_policy {
        margin: 10px auto;
        text-align: center;
        font-weight: bold;
    }
    #signature {
        margin-top: 25px;
        text-align: center;
        font-size: 0.9em;
    }
    /* --- IMPRESIÓN --- */
    @media print {
        .oculto-impresion { display: none !important; }
        #receipt_wrapper { margin: 0 auto; 
            page-break-inside: avoid;
    }
        @page {
            margin: 0; /* Quita margenes por defecto del navegador para que mande el CSS */
        }
        body { margin: 0; }
    }

    /* Botón cerrar */
    .btn-cerrar {
        background-color: #de3225;
        border: none;
        color: white;
        padding: 15px 0;
        text-align: center;
        text-decoration: none;
        display: block;
        font-size: 16px;
        width: 100%;
        cursor: pointer;
        margin-top: 20px;
        font-weight: bold;
    }

    /* Dentro de tu etiqueta <style> */
    .separador-factura {
        page-break-after: always; /* Fuerza salto de página al imprimir */
        margin-bottom: 50px;      /* Espacio visual si solo se ve en pantalla */
        border-bottom: 2px dashed #ccc; /* Opcional: una línea guía para corte manual */
    }

    @media print {
        .separador-factura {
            border-bottom: none; /* Quitamos la línea al imprimir */
        }
    }


</style>
</head>
<?php
    $number =count($_GET["ven_id"]);  
    if($number > 0)  
    {  
        for($i=0; $i<$number; $i++)  
        { 
             if(trim($_GET["ven_id"][$i] != '') )
                $ven_id=$_GET["ven_id"][$i]; 

            // html de la tirilla
            include('.tirilla.php'); 

        } 
    } 


}
else
{
    echo '<script>alert("primero debes Iniciar Cesion para ver esta pagina")</script>';
    echo '<script>location.href = "index.php";</script>';
}
?>
